using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carrie Van Stedum</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>08/26/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// EquipmentMaintenance data access layer class.
	///</summary>

	#endregion
	
	public class EquipmentMaintenance
	{

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5696"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>EquipmentMaintenance table schema</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5697"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates a blank EquipmentMaintenance Data Table
		/// </summary>
		/// <returns>Empty equipmement maintenance table</returns>
		public static System.Data.DataTable GetEmptyEquipmentMaintenanceTable()
		{
			System.Data.DataTable dtEmpty = new System.Data.DataTable(TABLE.EquipmentMaintenance.TableName);

			dtEmpty.Columns.Add(TABLE.EquipmentMaintenance.EquipmentMaintenanceGuid, typeof(Guid));
			dtEmpty.Columns.Add(TABLE.EquipmentMaintenance.EquipmentGuid, typeof(System.Guid));
			dtEmpty.Columns.Add(TABLE.EquipmentMaintenance.MaintenanceType, typeof(string));
			dtEmpty.Columns.Add(TABLE.EquipmentMaintenance.MaintenanceDate, typeof(System.DateTime));
			dtEmpty.Columns.Add(TABLE.EquipmentMaintenance.MaintenanceResults, typeof(string));
			dtEmpty.Columns.Add(TABLE.EquipmentMaintenance.PendingIssues, typeof(string));
			dtEmpty.Columns.Add(TABLE.EquipmentMaintenance.RowVersion, typeof(byte[]));
			dtEmpty.Columns.Add(TABLE.Equipment.DivisionCode, typeof(string));

			return(dtEmpty);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5698"> 
		///		<ExpectedInput>Valid equipment maintenance guid</ExpectedInput>
		///		<ExpectedOutput>equipment maintenance data table</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5699"> 
		///		<ExpectedInput>Empty guid</ExpectedInput>
		///		<ExpectedOutput>ArgumentException thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get equipment maintenance details for a given equipment maintenance guid
		/// </summary>
		/// <param name="equipmentMaintenanceGuid">Equipment maintenance unique identifier</param>
		/// <returns>equipment maintenance data table</returns>
		public static System.Data.DataTable GetEquipmentMaintenanceByGuid(System.Guid equipmentMaintenanceGuid)
		{
			if (equipmentMaintenanceGuid == Guid.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("equipment maintenance guid").ResString);
			}
			//
			SqlParameter[] _params = 
			{
				Common.StoredProcedure.MakeParameter(STOREDPROC.GetEquipmentMaintenanceByGuid.equipmentmaintenanceguid, equipmentMaintenanceGuid),
				Common.StoredProcedure.MakeParameter(STOREDPROC.GetEquipmentMaintenanceByGuid.divisioncode, Common.LogonUser.LogonUserDivisionCode)
			};

			return Common.StoredProcedure.GetData(STOREDPROC.GetEquipmentMaintenanceByGuid.StoredProcName, _params).Tables[0];
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5700"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Equipment maintenance data table for entire division</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5701"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all equipment maintenance entries for division
		/// </summary>
		/// <returns>equipment maintenance data table</returns>
		public static System.Data.DataTable GetEquipmentMaintenance()
		{
			SqlParameter[] _params = 
			{
				Common.StoredProcedure.MakeParameter(STOREDPROC.GetEquipmentMaintenance.divisioncode, Common.LogonUser.LogonUserDivisionCode)
			};

			return Common.StoredProcedure.GetData(STOREDPROC.GetEquipmentMaintenance.StoredProcName, _params).Tables[0];
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5702"> 
		///		<ExpectedInput>Valid equipment guid</ExpectedInput>
		///		<ExpectedOutput>Equipment maintenance data table for equipment</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5703"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>ArgumentException thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get equipment maintenance entries associated with an equipment item
		/// </summary>
		/// <param name="equipmentGuid">equipment maintenance unique identifier</param>
		/// <returns>equipment maintenance data table</returns>
		public static System.Data.DataTable GetEquipmentMaintenance(Guid equipmentGuid)
		{
			if (equipmentGuid == Guid.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("equipment guid").ResString);
			}
			//
			SqlParameter[] _params = 
			{
				Common.StoredProcedure.MakeParameter(STOREDPROC.GetEquipmentMaintenanceForEquipment.equipmentguid, equipmentGuid),
				Common.StoredProcedure.MakeParameter(STOREDPROC.GetEquipmentMaintenanceForEquipment.divisioncode, Common.LogonUser.LogonUserDivisionCode)
			};

			return Common.StoredProcedure.GetData(STOREDPROC.GetEquipmentMaintenanceForEquipment.StoredProcName, _params).Tables[0];
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5704"> 
		///		<ExpectedInput>Valid insert and update data tables</ExpectedInput>
		///		<ExpectedOutput>Success indicator = true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5705"> 
		///		<ExpectedInput>Insert table containing existing equipment maintenance entry</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Save equipment maintenance changes
		/// </summary>
		/// <param name="dtInsertEquipmentMaintenance">Data table of equipment maintenance entries to be inserted</param>
		/// <param name="dtUpdateEquipmentMaintenance">Data table of equipment maintenance entries to be updated</param>
		/// <param name="lastUpdateFunctionId">Last update function</param>
		/// <returns>Success indicator</returns>
		public static bool Save(DataTable dtInsertEquipmentMaintenance, DataTable dtUpdateEquipmentMaintenance, Common.UpdateFunction lastUpdateFunctionId)
		{
			DataTable[] dtArray = new DataTable[2];
			string[] spArray = new string[2];
			//
			dtArray[0] = Common.Utility.AppendLastUpdateInformation(dtInsertEquipmentMaintenance,lastUpdateFunctionId);
			spArray[0] = STOREDPROC.InsertEquipmentMaintenance.StoredProcName;
			//
			dtArray[1] = Common.Utility.AppendLastUpdateInformation(dtUpdateEquipmentMaintenance,lastUpdateFunctionId);
			spArray[1] = STOREDPROC.UpdateEquipmentMaintenance.StoredProcName;
			
			return (new StoredProcedure().TransactionalGetValue(spArray, dtArray) == 0);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5706"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Data table of maintenance types for division</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5707"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get previously entered maintenance types
		/// </summary>
		/// <returns>Data table of maintenance types</returns>
		public static DataTable GetMaintenanceTypes()
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetEquipmentMaintenanceTypes.divisioncode, System.Data.SqlDbType.Char)
			};
			
			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;

			return Common.StoredProcedure.GetData(STOREDPROC.GetEquipmentMaintenanceTypes.StoredProcName, prms).Tables[0];
		}
	}
}
